/*
 * Decompiled with CFR 0.152.
 */
package com.example.worldresetmod;

import com.example.worldresetmod.WorldResetMod;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.InputStreamReader;
import java.util.concurrent.TimeUnit;

public class AdminPermissionUtil {
    public static boolean isAdministrator() {
        try {
            Process process = Runtime.getRuntime().exec("net session");
            BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            String line = reader.readLine();
            int exitCode = process.waitFor();
            WorldResetMod.logger.info("Administrator check result: exit code " + exitCode);
            return exitCode == 0;
        }
        catch (Exception e) {
            WorldResetMod.logger.warn("Failed to check administrator status: " + e.getMessage());
            return false;
        }
    }

    public static boolean requestAdministratorPrivilege() {
        try {
            WorldResetMod.logger.info("Requesting administrator privilege elevation...");
            String javaPath = System.getProperty("java.home") + File.separator + "bin" + File.separator + "java";
            String classPath = System.getProperty("java.class.path");
            String mainClass = "com.example.worldresetmod.AdminDeleteMain";
            String scriptPath = AdminPermissionUtil.getModRootDirectory() + File.separator + "scripts" + File.separator + "admin_delete.bat";
            WorldResetMod.logger.info("Java path: " + javaPath);
            WorldResetMod.logger.info("Class path: " + classPath);
            WorldResetMod.logger.info("Script path: " + scriptPath);
            AdminPermissionUtil.createAdminDeleteMainClass();
            ProcessBuilder pb = new ProcessBuilder("powershell", "-Command", "Start-Process", "\"" + javaPath + "\"", "-ArgumentList", "\"-cp\", \"" + classPath + "\", \"" + mainClass + "\"", "-Verb", "RunAs");
            pb.redirectErrorStream(true);
            Process process = pb.start();
            Thread.sleep(1000L);
            WorldResetMod.logger.info("Administrator privilege request initiated");
            return true;
        }
        catch (Exception e) {
            WorldResetMod.logger.error("Failed to request administrator privilege: " + e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public static boolean executeAdminDelete(String worldName) {
        try {
            WorldResetMod.logger.info("Executing admin delete for world: " + worldName);
            String scriptPath = AdminPermissionUtil.getModRootDirectory() + File.separator + "scripts" + File.separator + "admin_delete.bat";
            File scriptFile = new File(scriptPath);
            if (!scriptFile.exists()) {
                WorldResetMod.logger.error("Admin delete script not found: " + scriptPath);
                return false;
            }
            File savesDir = AdminPermissionUtil.getSavesDirectory();
            if (savesDir == null) {
                WorldResetMod.logger.error("Failed to get saves directory");
                return false;
            }
            String targetFile = savesDir.getAbsolutePath() + File.separator + worldName + File.separator + "data" + File.separator + "overlast.dat";
            WorldResetMod.logger.info("Target file for admin deletion: " + targetFile);
            ProcessBuilder pb = new ProcessBuilder("cmd", "/c", "powershell", "-Command", "Start-Process", "\"" + scriptPath + "\"", "-ArgumentList", "\"" + targetFile + "\"", "-Verb", "RunAs");
            pb.redirectErrorStream(true);
            Process process = pb.start();
            boolean completed = process.waitFor(10L, TimeUnit.SECONDS);
            if (completed) {
                int exitCode = process.exitValue();
                WorldResetMod.logger.info("Admin delete process completed with exit code: " + exitCode);
                return exitCode == 0;
            }
            process.destroy();
            WorldResetMod.logger.warn("Admin delete process timed out");
            return false;
        }
        catch (Exception e) {
            WorldResetMod.logger.error("Failed to execute admin delete: " + e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public static boolean executeDirectAdminDelete(String filePath) {
        try {
            WorldResetMod.logger.info("Executing direct admin delete for: " + filePath);
            String psCommand = "Start-Process powershell -ArgumentList '-Command', 'Remove-Item -Path \\\"" + filePath + "\\\" -Force -ErrorAction Stop' -Verb RunAs";
            ProcessBuilder pb = new ProcessBuilder("cmd", "/c", psCommand);
            pb.redirectErrorStream(true);
            Process process = pb.start();
            boolean completed = process.waitFor(15L, TimeUnit.SECONDS);
            if (completed) {
                int exitCode = process.exitValue();
                WorldResetMod.logger.info("Direct admin delete completed with exit code: " + exitCode);
                File targetFile = new File(filePath);
                return !targetFile.exists();
            }
            process.destroy();
            WorldResetMod.logger.warn("Direct admin delete process timed out");
            return false;
        }
        catch (Exception e) {
            WorldResetMod.logger.error("Failed to execute direct admin delete: " + e.getMessage(), (Throwable)e);
            return false;
        }
    }

    private static void createAdminDeleteMainClass() {
        try {
            String sourcePath = AdminPermissionUtil.getModRootDirectory() + File.separator + "src" + File.separator + "main" + File.separator + "java" + File.separator + "com" + File.separator + "example" + File.separator + "worldresetmod" + File.separator + "AdminDeleteMain.java";
            File sourceFile = new File(sourcePath);
            if (sourceFile.exists()) {
                return;
            }
            String content = "package com.example.worldresetmod;\n\nimport java.io.*;\nimport java.nio.file.*;\n\npublic class AdminDeleteMain {\n    public static void main(String[] args) {\n        if (args.length < 1) {\n            System.err.println(\"Usage: AdminDeleteMain <file_path>\");\n            System.exit(1);\n        }\n        \n        String filePath = args[0];\n        System.out.println(\"AdminDeleteMain: Attempting to delete file: \" + filePath);\n        \n        try {\n            File file = new File(filePath);\n            if (file.exists()) {\n                boolean deleted = file.delete();\n                if (deleted) {\n                    System.out.println(\"AdminDeleteMain: File deleted successfully\");\n                    System.exit(0);\n                } else {\n                    System.err.println(\"AdminDeleteMain: Failed to delete file\");\n                    System.exit(1);\n                }\n            } else {\n                System.out.println(\"AdminDeleteMain: File does not exist\");\n                System.exit(0);\n            }\n        } catch (Exception e) {\n            System.err.println(\"AdminDeleteMain: Exception occurred: \" + e.getMessage());\n            e.printStackTrace();\n            System.exit(1);\n        }\n    }\n}\n";
            File parentDir = sourceFile.getParentFile();
            if (!parentDir.exists()) {
                parentDir.mkdirs();
            }
            try (FileWriter writer = new FileWriter(sourceFile);){
                writer.write(content);
            }
            WorldResetMod.logger.info("AdminDeleteMain class created at: " + sourcePath);
        }
        catch (Exception e) {
            WorldResetMod.logger.warn("Failed to create AdminDeleteMain class: " + e.getMessage());
        }
    }

    private static String getModRootDirectory() {
        try {
            File currentDir = new File(".");
            return currentDir.getAbsolutePath();
        }
        catch (Exception e) {
            WorldResetMod.logger.warn("Failed to get mod root directory: " + e.getMessage());
            return System.getProperty("user.dir");
        }
    }

    private static File getSavesDirectory() {
        try {
            String minecraftDir = System.getenv("APPDATA") + File.separator + ".minecraft";
            File savesDir = new File(minecraftDir, "saves");
            if (!savesDir.exists()) {
                File userHome = new File(System.getProperty("user.home"));
                File alternativeSaves = new File(userHome, "AppData/Roaming/.minecraft/saves");
                if (alternativeSaves.exists()) {
                    return alternativeSaves;
                }
                File currentSaves = new File("saves");
                if (currentSaves.exists()) {
                    return currentSaves;
                }
            }
            return savesDir;
        }
        catch (Exception e) {
            WorldResetMod.logger.error("Failed to get saves directory", (Throwable)e);
            return null;
        }
    }
}

